package h.com.newserialapp.activity.ConfigActivity;

import android.graphics.Typeface;
import android.os.Bundle;
import android.serialport.SerialPortFinder;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;

import h.com.newserialapp.R;
import h.com.newserialapp.util.PrefHelper;
import h.com.newserialapp.util.ToastUtil;
import h.com.newserialapp.util.Tools;
import h.com.newserialapp.util.constant.PreferenceKeys;
import h.com.serialportapi.comn.Device;
import h.com.serialportapi.comn.SerialPortManager;

import static butterknife.internal.Utils.arrayOf;

/**
 * Created by hxd on 2018/11/28.
 */

public class SerialPortConfigurationActivity extends AppCompatActivity
//        implements AdapterView.OnItemSelectedListener
{
    private String[] mDevices;
    private String[] mBaudrates;

    private int mDeviceIndex = 0;
    private int mBaudrateIndex = 0;
    private Device mDevice;
    //private Spinner spinner_baudrate;
    //private Spinner spinner_devices;
    private Button btOpen;
    private Button btClose;
    private boolean isOpen;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_serial_port_configuration);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

        //bindView();

        btOpen = findViewById(R.id.bt_open);
        btClose = findViewById(R.id.bt_close);

        mDevice = new Device("/dev/ttyS3", "115200");

        btClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!isOpen) {
                    SerialPortManager.instance().close();
                } else {
                    Tools.showToast(SerialPortConfigurationActivity.this, "Please check the equipment.");
                }
            }
        });

        btOpen.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                isOpen = SerialPortManager.instance().open(mDevice) != null;
                if (isOpen) {
                    PrefHelper.getDefault().saveInt(PreferenceKeys.SERIAL_PORT_DEVICES, mDeviceIndex);
                    PrefHelper.getDefault().saveInt(PreferenceKeys.BAUD_RATE, mBaudrateIndex);
                    Tools.showToast(SerialPortConfigurationActivity.this, "Device Serial Port is Opened - " + mDevice.getPath() + " - " + mDevice.getBaudrate());
                    //   startActivity(new Intent(SerialPortConfigurationActivity.this,);
                    //    finish();
                } else {
                    Tools.showToast(SerialPortConfigurationActivity.this, "Please check the equipment - " + mDevice.getPath() + " - " + mDevice.getBaudrate());
                }
            }
        });


    }

    /*void bindView() {
        Typeface typeface = Typeface.createFromAsset(this.getAssets(), "fonts/Eurostile LT Demi.ttf");
        spinner_devices = findViewById(R.id.spinner_devices);
        spinner_baudrate = findViewById(R.id.spinner_baudrate);
        btOpen = findViewById(R.id.bt_open);
        btClose = findViewById(R.id.bt_close);
        btOpen.setTypeface(typeface);
        btClose.setTypeface(typeface);
        SerialPortFinder serialPortFinder = new SerialPortFinder();
        // 设备
        mDevices = serialPortFinder.getAllDevicesPath();
        if (mDevices.length == 0) {
            mDevices = arrayOf(getString(R.string.serial_port_not_found));
        }

        // 波特率
        mBaudrates = getResources().getStringArray(R.array.baudrates);

        mDeviceIndex = PrefHelper.getDefault().getInt(PreferenceKeys.SERIAL_PORT_DEVICES, 0);
        mDeviceIndex = (mDeviceIndex >= mDevices.length ? mDevices.length - 1 : mDeviceIndex);
        mBaudrateIndex = PrefHelper.getDefault().getInt(PreferenceKeys.BAUD_RATE, 0);
        //mDevice = new Device(mDevices[mDeviceIndex], mBaudrates[mBaudrateIndex]);
        mDevice = new Device("/dev/ttyS3", "115200");
        ArrayAdapter deviceAdapter = new ArrayAdapter<String>(this, R.layout.spinner_default_item, mDevices);
        deviceAdapter.setDropDownViewResource(R.layout.spinner_item);
        spinner_devices.setAdapter(deviceAdapter);
        spinner_devices.setOnItemSelectedListener(this);


        ArrayAdapter baudrateAdapter = new ArrayAdapter<String>(this, R.layout.spinner_default_item, mBaudrates);
        baudrateAdapter.setDropDownViewResource(R.layout.spinner_item);
        spinner_baudrate.setAdapter(baudrateAdapter);
        spinner_baudrate.setOnItemSelectedListener(this);

        spinner_devices.setSelection(mDeviceIndex);
        spinner_baudrate.setSelection(mBaudrateIndex);

        btClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!isOpen) {
                    SerialPortManager.instance().close();
                } else {
                    Tools.showToast(SerialPortConfigurationActivity.this, "Please check the equipment.");
                }
            }
        });
        btOpen.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                isOpen = SerialPortManager.instance().open(mDevice) != null;
                if (isOpen) {
                    PrefHelper.getDefault().saveInt(PreferenceKeys.SERIAL_PORT_DEVICES, mDeviceIndex);
                    PrefHelper.getDefault().saveInt(PreferenceKeys.BAUD_RATE, mBaudrateIndex);
                    Tools.showToast(SerialPortConfigurationActivity.this, "Device Serial Port is Opened - " + mDevice.getPath() + " - " + mDevice.getBaudrate());
                    //   startActivity(new Intent(SerialPortConfigurationActivity.this,);
                    //    finish();
                } else {
                    Tools.showToast(SerialPortConfigurationActivity.this, "Please check the equipment - " + mDevice.getPath() + " - " + mDevice.getBaudrate());
                }
            }
        });
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        switch (parent.getId()) {
            case R.id.spinner_baudrate:
                mBaudrateIndex = position;
                mDevice.setBaudrate(mBaudrates[mBaudrateIndex]);
                break;
            case R.id.spinner_devices:
                mDeviceIndex = position;
                mDevice.setPath(mDevices[mDeviceIndex]);
                break;
        }
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {

    }*/
}
